package com.team5.aLife.Client;

public class UpdateDeviceStateRequest extends AbstractRequest {

	enum Action {		
		ACTIVATE,
		DEACTIVATE,
		UPDATE_PARAMS,
	}
	
	private Device device;
	private Thermostat thermostat;
	private Action action;
	
	public UpdateDeviceStateRequest(){
		//  Do nothing.  Needed for JSON
	}
	
	public UpdateDeviceStateRequest(Device device, Action action)
	{
		this.device = device;
		this.action = action;
	}
	
	public UpdateDeviceStateRequest(Thermostat thermostat, Action action)
	{
		this.thermostat = thermostat;
		this.action = action;
	}
	
	@Override
	public int getRequestType() {
		// TODO Auto-generated method stub
		return UPDATE_DEVICE_STATE;
	}
	
	public Action getAction(){
		return action;
	}
	
	public Device getDevice(){
		if (action == Action.UPDATE_PARAMS)
			return thermostat;
		else
			return device;
	}

}
